//******************************************************************  
//That can't be modified by user.
//******************************************************************  
void	I2C_Init(void);
void	Entry_I2C_mode(void);
void	NPH_RX_Init(void);
void	Exit_I2C_mode(void);
void	RX_Off(void);
void	RX_On(void);
void	Delay_1ms(void);
void	InitRxTM(void);
void	RFTimerOn(void);
void	RFTimerOff(void);
void	dataProcess(void);
void    Read_NPH_RX_Reg();

#pragma	rambank0
extern	bit fRxBusy;
extern	bit fRxFmtFnd;
extern	bit fRxDtaOk;
extern  bit fsetting_time;
extern  unsigned char setting_time_cnt;
#pragma	norambank


//-------------------------------------------------------
extern	unsigned char mRFData[];		//RF data buffer

//-------------------------------------------------------
// to initialize RF chip
//-------------------------------------------------------
#define	RF_Configuration()	I2C_Init(); 			\
							Entry_I2C_mode();		\
							NPH_RX_Init();			\
							Exit_I2C_mode();		\
							RX_Off();

//-------------------------------------------------------
#define	f_RX_Running		fRxBusy			//RX running flag
#define	f_RX_Frm			fRxFmtFnd		//RX format valid flag
#define	f_RX_Dta			fRxDtaOk			//RX data valid flag

#define	Clr_RX_Frm_Flag()	fRxFmtFnd=0
#define	Clr_RX_Dta_Flag()	fRxDtaOk=0

#define	Enable_Decode()		fRxFmtFnd=0;	\
							fRxBusy=1;		\
							RFTimerOn();							

#define	Disable_Decode()	fRxBusy=0;		\
							RFTimerOff();	\
							fRxFmtFnd=0
							
#define	Enable_RX()			InitRxTM();		\
							RX_On();		\
							Enable_Decode()
										
#define	Disable_RX()		Disable_Decode();	\
							RX_Off();
							
//mRFData[3] = data, mRFData[2:0] = address										
#define	Read_RF_AddrDta()	Clr_RX_Frm_Flag();	\
							Disable_Decode();	\
							dataProcess();		\
							Enable_Decode()												

//-------------------------------------------------------
